package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestEventType extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testZero() throws Exception {
		
		// test that the reference values in the Role class are in sync with what the database should contain
		
		EventType.initialize();
		
		EventType e1 = EventType.findById(1);
		Assert.assertNotNull(e1);
		Assert.assertEquals(e1.getId(), 1);
		Assert.assertEquals(e1, EventType.INITIATE_REQUEST);
		Assert.assertEquals(e1.getName(), "Initiated");

		EventType e2 = EventType.findById(2);
		Assert.assertNotNull(e2);
		Assert.assertEquals(e2.getId(), 2);
		Assert.assertEquals(e2, EventType.SUBMIT_REQUEST);
		Assert.assertEquals(e2.getName(), "Submitted");

		EventType e3 = EventType.findById(3);
		Assert.assertNotNull(e3);
		Assert.assertEquals(e3.getId(), 3);
		Assert.assertEquals(e3, EventType.AMEND_REQUEST);
		Assert.assertEquals(e3.getName(), "Request Amendment Created");

		EventType e4 = EventType.findById(4);
		Assert.assertNotNull(e4);
		Assert.assertEquals(e4.getId(), 4);
		Assert.assertEquals(e4, EventType.SUBMIT_CHANGE_REQUEST);
		Assert.assertEquals(e4.getName(), "Request Submitted with Changes");
		
		EventType e5 = EventType.findById(5);
		Assert.assertNotNull(e5);
		Assert.assertEquals(e5.getId(), 5);
		Assert.assertEquals(e5, EventType.CLOSE_REQUEST);
		Assert.assertEquals(e5.getName(), "Closed");

		EventType e6 = EventType.findById(6);
		Assert.assertNotNull(e6);
		Assert.assertEquals(e6.getId(), 6);
		Assert.assertEquals(e6, EventType.APPROVE_REVIEW);
		Assert.assertEquals(e6.getName(), "Review Approval");

		EventType e7 = EventType.findById(7);
		Assert.assertNotNull(e7);
		Assert.assertEquals(e7.getId(), 7);
		Assert.assertEquals(e7, EventType.DENY_REVIEW);
		Assert.assertEquals(e7.getName(), "Review Denied");

		EventType e8 = EventType.findById(8);
		Assert.assertNotNull(e8);
		Assert.assertEquals(e8.getId(), 8);
		Assert.assertEquals(e8, EventType.CHANGE_REQUEST);
		Assert.assertEquals(e8.getName(), "Change Requested");

		EventType e9 = EventType.findById(9);
		Assert.assertNotNull(e9);
		Assert.assertEquals(e9.getId(), 9);
		Assert.assertEquals(e9, EventType.SENT_FOR_REVIEW);
		Assert.assertEquals(e9.getName(), "Request Sent for Review");

		EventType e10 = EventType.findById(10);
		Assert.assertNotNull(e10);
		Assert.assertEquals(e10.getId(), 10);
		Assert.assertEquals(e10, EventType.APPROVE_WORKFLOW);
		Assert.assertEquals(e10.getName(), "Request Approval");
	}
	
	@Test
	public void testOne() throws Exception {
		try {
			DartObjectFactory.getInstance().getEventTypeDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}
		
		List<EventType> dtList = EventType.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
	}

	@Test
	public void testTwo() throws Exception {
		
		List<EventType> etList = EventType.listAll();
		Assert.assertNotNull(etList);
		Assert.assertTrue(etList.size() > 0);
		
		EventType et = etList.get(0);
		Assert.assertNotNull(et);
		Assert.assertTrue(et.getId() > 0);
		
		EventType et2 = EventType.findById(et.getId());
		Assert.assertNotNull(et2);
		Assert.assertEquals(et2, et);
	}
	
	/*
	 * findById(int)
	 * listAll()
	 * getEventDescription()
	 * 
	 */
}
